/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class Util {
    private Util() {
    }

    public static WorkplaceActivity getLastPlannedWa(Operation op) {
        return Util.getBorderActivityChange(op, SearchDirection.BACKWARD, ActivityChange.ChangeType.ADDED, WorkplaceActivity.class);
    }

    public static WorkplaceActivity getLastPlannedWa(Operation.OperationPlanning planning) {
        return Util.getBorderActivityChange(planning, SearchDirection.BACKWARD, ActivityChange.ChangeType.ADDED, WorkplaceActivity.class);
    }

    public static WorkplaceActivity getFirstPlannedWa(Operation.OperationPlanning planning) {
        return Util.getBorderActivityChange(planning, SearchDirection.FORWARD, ActivityChange.ChangeType.ADDED, WorkplaceActivity.class);
    }

    public static WorkplaceActivity getFirstPlannedWa(Operation op) {
        return Util.getBorderActivityChange(op, SearchDirection.FORWARD, ActivityChange.ChangeType.ADDED, WorkplaceActivity.class);
    }

    public static ActionActivity getFirstPlannedAa(Operation op) {
        return Util.getBorderActivityChange(op, SearchDirection.FORWARD, ActivityChange.ChangeType.ADDED, ActionActivity.class);
    }

    public static ActionActivity getFirstPlannedAa(Operation.OperationPlanning planning) {
        return Util.getBorderActivityChange(planning, SearchDirection.FORWARD, ActivityChange.ChangeType.ADDED, ActionActivity.class);
    }

    public static ActionActivity getLastPlannedAa(Operation op) {
        return Util.getBorderActivityChange(op, SearchDirection.BACKWARD, ActivityChange.ChangeType.ADDED, ActionActivity.class);
    }

    public static Set<Workplace> getUsedWorkplaces(Operation.OperationPlanning planning) {
        Set<Workplace> res = Sets.newIdentityHashSet();
        for (ActivityChange ac : planning.getActivityChanges()) {
            if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof WorkplaceActivity)) continue;
            res.add(((WorkplaceActivity)ac.getActivity()).getWorkplace());
        }
        return res;
    }

    public static ActionActivity getLastPlannedAa(Operation.OperationPlanning planning) {
        return Util.getBorderActivityChange(planning, SearchDirection.BACKWARD, ActivityChange.ChangeType.ADDED, ActionActivity.class);
    }

    private static <T extends WorkplaceActivity> T getBorderActivityChange(Operation op, SearchDirection direction, ActivityChange.ChangeType requestedType, Class<T> actClass) {
        Preconditions.checkArgument(op.isPlanned(), "Operation is not planned.");
        return Util.getBorderActivityChange(op.getPlannings().get(0), direction, requestedType, actClass);
    }

    private static <T extends WorkplaceActivity> T getBorderActivityChange(Operation.OperationPlanning planning, SearchDirection direction, ActivityChange.ChangeType requestedType, Class<T> actClass) {
        List<ActivityChange> changes = planning.getActivityChanges();
        ListIterator<ActivityChange> iterator = null;
        iterator = direction == SearchDirection.FORWARD ? changes.listIterator() : changes.listIterator(changes.size());
        while (direction == SearchDirection.FORWARD && iterator.hasNext() || direction == SearchDirection.BACKWARD && iterator.hasPrevious()) {
            ActivityChange change = null;
            change = direction == SearchDirection.FORWARD ? iterator.next() : iterator.previous();
            Activity activity = change.getActivity();
            ActivityChange.ChangeType type = change.getChangeType();
            if (requestedType != null && type != requestedType || actClass != null && !actClass.isInstance(activity)) continue;
            WorkplaceActivity res = (WorkplaceActivity)activity;
            return (T)res;
        }
        return null;
    }

    public static long getPreviousOperationEnd(Operation op) {
        long res = Long.MIN_VALUE;
        Set<Operation> preds = op.getPredecessors();
        if (!preds.isEmpty()) {
            for (Operation pred : preds) {
                if (!pred.isPlanned()) continue;
                long predEnd = Util.getLastPlannedWa(pred).getEnd();
                if (res != Long.MIN_VALUE && predEnd >= res) continue;
                res = predEnd;
            }
        } else {
            GeneralizedOrderRequest gor = (GeneralizedOrderRequest)op.getGar().getParent();
            GeneralizedRequest prevGar = null;
            for (GeneralizedActionRequest gar : gor.getGars()) {
                if (gar == op.getGar()) break;
                prevGar = gar;
            }
            if (prevGar != null && prevGar.getEndDate() != -9223372036854775708L) {
                res = prevGar.getEndDate();
            }
        }
        return res;
    }

    private static enum SearchDirection {
        FORWARD,
        BACKWARD;

    }
}

